/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.exporters;

import LegendaryCardMaker.DividerMaker;
import LegendaryCardMaker.LegendaryCardMaker;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.HeroDividerMaker;
import LegendaryCardMaker.LegendaryDividerMaker.VillainDividerMaker;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryVillainMaker.Villain;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import org.w3c.dom.Element;

public class ExportDividersHomeprintProgressBarDialog
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JProgressBar progressBar;
    private Task task;
    private int maxValue;
    private int currentValue;
    private LegendaryCardMaker lcm;
    private File folder;
    private JDialog frame;
    private String exportFileName = "dividers_";

    public ExportDividersHomeprintProgressBarDialog(int maxValue, LegendaryCardMaker lcm, File folder) {
        super(new BorderLayout());
        this.lcm = lcm;
        this.folder = folder;
        this.maxValue = maxValue;
        this.progressBar = new JProgressBar(0, maxValue);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        JPanel panel = new JPanel();
        panel.add(this.progressBar);
        this.add((Component)panel, "First");
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void createAndShowGUI() {
        this.frame = new JDialog();
        this.frame.setTitle("Exporting (" + (this.getCurrentValue() + 1) + "/" + "..." + ")...");
        this.frame.setModal(true);
        this.frame.setDefaultCloseOperation(2);
        this.setOpaque(true);
        this.frame.setContentPane(this);
        this.task = new Task();
        this.task.setBar(this);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void hideGUI() {
        this.frame.setVisible(false);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public int getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(int currentValue) {
        this.currentValue = currentValue;
    }

    public static void exportToJPEG(BufferedImage image, File newFile) throws Exception {
        int dpi = 300;
        FileOutputStream fos = new FileOutputStream(newFile);
        ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
        ImageOutputStream ios = ImageIO.createImageOutputStream(fos);
        imageWriter.setOutput(ios);
        IIOMetadata imageMetaData = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
        Element tree = (Element)imageMetaData.getAsTree("javax_imageio_jpeg_image_1.0");
        Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
        jfif.setAttribute("Xdensity", Integer.toString(dpi));
        jfif.setAttribute("Ydensity", Integer.toString(dpi));
        jfif.setAttribute("resUnits", "1");
        imageMetaData.setFromTree("javax_imageio_jpeg_image_1.0", tree);
        JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
        jpegParams.setCompressionMode(2);
        jpegParams.setCompressionQuality(1.0f);
        imageWriter.write(null, new IIOImage(image, null, imageMetaData), jpegParams);
        ios.close();
        imageWriter.dispose();
    }

    private void exportVerticalDividers() {
    }

    class Task
    extends SwingWorker<Void, Void> {
        private ExportDividersHomeprintProgressBarDialog bar;

        Task() {
        }

        @Override
        public Void doInBackground() throws Exception {
            DividerMaker hm;
            ArrayList<HeroDividerMaker> cardMakers = new ArrayList<HeroDividerMaker>();
            int max = 0;
            for (Hero h : ((ExportDividersHomeprintProgressBarDialog)ExportDividersHomeprintProgressBarDialog.this).lcm.heroes) {
                hm = new HeroDividerMaker(h, LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal);
                cardMakers.add((HeroDividerMaker)hm);
                ++max;
            }
            for (Villain v : ((ExportDividersHomeprintProgressBarDialog)ExportDividersHomeprintProgressBarDialog.this).lcm.villains) {
                if (v.name.toLowerCase().equals("system_bystander_villain") || v.name.toLowerCase().equals("system_wound_villain") || v.name.toLowerCase().equals("system_bindings_villain")) continue;
                hm = new VillainDividerMaker(v, LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal);
                cardMakers.add((HeroDividerMaker)hm);
                ++max;
            }
            ExportDividersHomeprintProgressBarDialog.this.setMaxValue(max);
            double progressDouble = 0.0;
            double progressIncrement = 100.0 / (double)max;
            ExportDividersHomeprintProgressBarDialog.this.progressBar.setMaximum(100);
            int cardWidth = DividerMaker.getWidth();
            int cardHeight = DividerMaker.getHeight();
            int dpi = 300;
            double xPadding = 0.0;
            double yPadding = 0.02;
            if (!LegendaryCardMakerFrame.lcmf.lcm.dividerHorizontal) {
                xPadding = 0.0;
            }
            int w = cardWidth;
            int xPad = (int)((double)cardWidth * xPadding);
            int fullW = w + xPad + xPad;
            int h = cardHeight;
            int yPad = (int)((double)cardHeight * yPadding);
            int fullH = h + yPad + yPad;
            int i = 0;
            int j = 1;
            int type = 1;
            BufferedImage image = new BufferedImage(fullW * DividerMaker.getDividersPerRow(), fullH * DividerMaker.getDividerRows(), type);
            Graphics g = image.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            int x = xPad;
            int y = yPad;
            for (DividerMaker dividerMaker : cardMakers) {
                BufferedImage bi = dividerMaker.generateDivider();
                g.drawImage(bi, x, y, null);
                g.setColor(Color.LIGHT_GRAY);
                g.drawRect(x, y, bi.getWidth(), bi.getHeight());
                if ((x += bi.getWidth() + xPad + xPad) >= (xPad + xPad + bi.getWidth()) * DividerMaker.getDividersPerRow()) {
                    y += bi.getHeight() + yPad + yPad;
                    x = xPad;
                }
                if (++i == DividerMaker.getDividersPerRow() * DividerMaker.getDividerRows()) {
                    i = 0;
                    x = xPad;
                    y = yPad;
                    try {
                        File newFile = new File(String.valueOf(((ExportDividersHomeprintProgressBarDialog)ExportDividersHomeprintProgressBarDialog.this).lcm.exportFolder) + File.separator + ExportDividersHomeprintProgressBarDialog.this.exportFileName + j + ".jpg");
                        ExportDividersHomeprintProgressBarDialog.exportToJPEG(image, newFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    g.dispose();
                    image = new BufferedImage(fullW * DividerMaker.getDividersPerRow(), fullH * DividerMaker.getDividerRows(), type);
                    g = image.getGraphics();
                    g.setColor(Color.white);
                    g.fillRect(0, 0, image.getWidth(), image.getHeight());
                    ++j;
                }
                ExportDividersHomeprintProgressBarDialog.this.frame.setTitle("Exporting (" + (ExportDividersHomeprintProgressBarDialog.this.getCurrentValue() + 1) + "/" + ExportDividersHomeprintProgressBarDialog.this.getMaxValue() + ")...");
                ExportDividersHomeprintProgressBarDialog exportDividersHomeprintProgressBarDialog = ExportDividersHomeprintProgressBarDialog.this;
                exportDividersHomeprintProgressBarDialog.currentValue = exportDividersHomeprintProgressBarDialog.currentValue + 1;
                this.setProgress((int)(progressDouble += progressIncrement));
            }
            if (i < DividerMaker.getDividersPerRow() * DividerMaker.getDividerRows() && i > 0) {
                i = 0;
                try {
                    File file = new File(String.valueOf(((ExportDividersHomeprintProgressBarDialog)ExportDividersHomeprintProgressBarDialog.this).lcm.exportFolder) + File.separator + ExportDividersHomeprintProgressBarDialog.this.exportFileName + j + ".jpg");
                    ExportDividersHomeprintProgressBarDialog.exportToJPEG(image, file);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++j;
            }
            return null;
        }

        @Override
        public void done() {
            this.bar.hideGUI();
        }

        public ExportDividersHomeprintProgressBarDialog getBar() {
            return this.bar;
        }

        public void setBar(ExportDividersHomeprintProgressBarDialog bar) {
            this.bar = bar;
        }
    }
}

